#ifndef VAKIOT_H
#define VAKIOT_H

#include <math.h>       /* atan */
#include <vector>
#include <iostream>
#include <assert.h>

#define PI 3.14159265

/* Silmien korkeus maanpinnasta. */
static const double korkeus = 1.2;

static const double nakokenttax = 50.0;
static const double nakokenttay = nakokenttax/(4/3);
static const double herz = 60;

static double nopeus=70;
static double vakionopeus=80;
static double aika=0;

static double kaista=0;
static double kaistan=0;

static int poljin_kaasu=0;
static int poljin_jarru=0;
static double matka=0;

static std::vector<double> acceleration{
    0,
    0.55,
    1.1,
    1.6,
    2.1,
    2.5,
    2.9,
    3.4,
    3.8,
    4.8,
    5.5,    //100
    6.2,
    7.0,
    8.1,
    9.2,
    10.2,
    11.4,
    13.2,
    14.8,
    16.5,
    18.4,   //200
    20.7,
    24.4,
    28.3,
    32.8
};

double kulma(const double etaisyys){
    return atan(korkeus/etaisyys)*180/PI;
}

double y(const double kulma){
    return 0.5+kulma/nakokenttay;
}

/* Kiihtyvyys km/h/s nopeudelle km/h */
double kiihtyvyysnopeudelle(double nopeus){
    int vali = nopeus/10;
    double aika=acceleration[vali+1]-acceleration[vali];
    double kiihtyvyys = 10/aika;
    return kiihtyvyys;
}

/* Palauttaa ilmanvastuksen vaikutuksen negatiivisena kiihtyvyytenä (km/h/s). */
double ilmanvastusnopeudelle(double nopeus){
    double kiiht = kiihtyvyysnopeudelle(nopeus)-kiihtyvyysnopeudelle(1.0);
    return kiiht;
}

void kiihdyta(){
    if(nopeus<240){
        nopeus+=kiihtyvyysnopeudelle(nopeus)*poljin_kaasu/3.0/60;
    }
    if(poljin_jarru>0){
        nopeus+=ilmanvastusnopeudelle(nopeus)/60;
        nopeus-=poljin_jarru*0.15;
    }
    if(nopeus<0){
        nopeus=0;
        poljin_jarru=0;
    }

    kaista+=kaistan*nopeus;
    if(kaista<0){
        kaista=0;
        kaistan=0;
    }
    if(kaista>2){
        kaista=2;
        kaistan=0;
    }
}

void saadavakionopeus(){
    if(vakionopeus){
        if(nopeus+1 < vakionopeus){
            poljin_kaasu=1;
            poljin_jarru=0;
        }
        if(nopeus-1 > vakionopeus){
            poljin_kaasu=0;
            poljin_jarru=1;
        }
    }
}

void siirra(){
   aika++;
   saadavakionopeus();
   kiihdyta();
   //std::cout << nopeus << " " << matka << std::endl;
   matka+=nopeus*1000/60.0/60.0/herz;

}

void kaasuta(){
    poljin_kaasu++;
    if(poljin_kaasu>3){
        poljin_kaasu=3;
    }
    poljin_jarru=0;
}

void jarruta(){
    poljin_jarru++;
    if(poljin_jarru>3){
        poljin_jarru=3;
    }
    poljin_kaasu=0;
}

void setvakionopeus(double nopeus){
    vakionopeus=nopeus;
}

//kuinka pitkän matkat muut autot ovat kulkeneet pelin alusta
double muidenMatka(double kmh){
    //const double kmh = 80;
    return aika/60/60/60*kmh*1000+10;
}

#endif // VAKIOT_H
