/*This source code copyrighted by Lazy Foo' Productions (2004-2020)
and may not be redistributed without written permission.*/

//Using SDL, SDL_image, standard IO, math, and strings
#include <SDL2/SDL.h>
//#include <SDL2/SDL_image.h>
#include <stdio.h>
#include <string>
#include <cmath>

#include <assert.h>
#include "vakiot.h"
#include "shapes.h"

//Screen dimension constants
const int SCREEN_WIDTH = 640;
const int SCREEN_HEIGHT = 480;
const int WINDOW_HEIGHT = 320;

//Key press surfaces constants
enum KeyPressSurfaces
{
    KEY_PRESS_SURFACE_DEFAULT,
    KEY_PRESS_SURFACE_UP,
    KEY_PRESS_SURFACE_DOWN,
    KEY_PRESS_SURFACE_LEFT,
    KEY_PRESS_SURFACE_RIGHT,
    KEY_PRESS_SURFACE_TOTAL
};

//Starts up SDL and creates window
bool init();

//Loads media
bool loadMedia();

//Frees media and shuts down SDL
void close();

//Loads individual image as texture
//static SDL_Texture* loadTexture( std::string path );

//The window we'll be rendering to
static SDL_Window* gWindow = nullptr;

//The window renderer
static SDL_Renderer* gRenderer = nullptr;


bool init()
{
	//Initialization flag
	bool success = true;

	//Initialize SDL
	if( SDL_Init( SDL_INIT_VIDEO ) < 0 )
	{
		printf( "SDL could not initialize! SDL Error: %s\n", SDL_GetError() );
		success = false;
	}
	else
	{
		//Set texture filtering to linear
		if( !SDL_SetHint( SDL_HINT_RENDER_SCALE_QUALITY, "1" ) )
		{
			printf( "Warning: Linear texture filtering not enabled!" );
		}

		//Create window
        gWindow = SDL_CreateWindow( "TRIVE", SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED, SCREEN_WIDTH, SCREEN_HEIGHT, SDL_WINDOW_SHOWN );
        if( gWindow == nullptr )
		{
			printf( "Window could not be created! SDL Error: %s\n", SDL_GetError() );
			success = false;
        }
        else
		{
			//Create renderer for window
            //gRenderer = SDL_CreateRenderer( gWindow, -1, SDL_RENDERER_ACCELERATED );
            gRenderer = SDL_CreateRenderer( gWindow, -1, SDL_RENDERER_ACCELERATED | SDL_RENDERER_PRESENTVSYNC );

            if( gRenderer == nullptr )
			{
				printf( "Renderer could not be created! SDL Error: %s\n", SDL_GetError() );
				success = false;
			}
			else
			{
				//Initialize renderer color
                SDL_SetRenderDrawColor( gRenderer, 0xFF, 0xFF, 0xFF, 0xFF );

				//Initialize PNG loading
/*                int imgFlags = IMG_INIT_PNG;
                if( !( IMG_Init( imgFlags ) & imgFlags ) )
				{
					printf( "SDL_image could not initialize! SDL_image Error: %s\n", IMG_GetError() );
                    success = false;
                }*/
            }
		}
	}

	return success;
}

bool loadMedia()
{
	//Loading success flag
	bool success = true;

	//Nothing to load
	return success;
}

void close()
{
	//Destroy window	
	SDL_DestroyRenderer( gRenderer );
	SDL_DestroyWindow( gWindow );
    gWindow = nullptr;
    gRenderer = nullptr;

	//Quit SDL subsystems
    //IMG_Quit();
	SDL_Quit();
}

/*
SDL_Texture* loadTexture( std::string path )
{
	//The final texture
    SDL_Texture* newTexture = nullptr;

	//Load image at specified path
	SDL_Surface* loadedSurface = IMG_Load( path.c_str() );
    if( loadedSurface == nullptr )
	{
		printf( "Unable to load image %s! SDL_image Error: %s\n", path.c_str(), IMG_GetError() );
	}
	else
	{
		//Create texture from surface pixels
        newTexture = SDL_CreateTextureFromSurface( gRenderer, loadedSurface );
        if( newTexture == nullptr )
		{
			printf( "Unable to create texture from %s! SDL Error: %s\n", path.c_str(), SDL_GetError() );
		}

		//Get rid of old loaded surface
		SDL_FreeSurface( loadedSurface );
	}

	return newTexture;
}
*/

void piirraNopeusmittariSade(double nopeus, double r_start, double r_end){
    double radnopeus = nopeus/200*PI-PI*0.25;
    SDL_RenderDrawLine( gRenderer,
                        SCREEN_WIDTH*0.3-cos(radnopeus)*r_start, SCREEN_HEIGHT*0.88-sin(radnopeus)*r_start,
                        SCREEN_WIDTH*0.3-cos(radnopeus)*r_end, SCREEN_HEIGHT*0.88-sin(radnopeus)*r_end);
}

void piirraNopeusmittari(){
    for(int n=0; n<=320; n+=20){
        SDL_SetRenderDrawColor( gRenderer, 0xFF, 0x80, 0x00, 0xFF );
        piirraNopeusmittariSade(n, SCREEN_WIDTH/9, SCREEN_WIDTH/11.5);
        SDL_SetRenderDrawColor( gRenderer, 0x80, 0x40, 0x00, 0xFF );
        piirraNopeusmittariSade(n+10, SCREEN_WIDTH/9, SCREEN_WIDTH/11.5);
    }
    SDL_SetRenderDrawColor( gRenderer, 0xFF, 0x80, 0x00, 0xFF );
    piirraNopeusmittariSade(nopeus, -SCREEN_WIDTH/60, SCREEN_WIDTH/11.5);
}

void peilaaObjekti(std::vector<p>* objekti){

    std::cout << objekti->size() << std::endl;
    for(long i=objekti->size()-2; i>=0; i--){
        std::cout << i << std::endl;
        p piste = objekti->at(i);
        piste.x=-piste.x;
        objekti->push_back(piste);
    }
    std::cout << objekti->size() << std::endl;
}


void piirraObjekti(std::vector<p> objekti, double etuk, double kaista){
    for(unsigned int i=0; i<volvo.size()-1; i++){
        //double paikkax1=0.7-2+kaista;
        //double paikkax2=-0.7-2+kaista;

        double skaala=0.15;
        double paikkax1=objekti.at(i).x*skaala*0.7+kaista;
        double paikkax2=objekti.at(i+1).x*skaala*0.7+kaista;

        double paikkay1=-objekti.at(i).y*skaala+korkeus;
        double paikkay2=-objekti.at(i+1).y*skaala+korkeus;

        SDL_RenderDrawLine(gRenderer,
                           y(etuk*paikkax1)*SCREEN_WIDTH, WINDOW_HEIGHT*y(etuk*paikkay1),
                           y(etuk*paikkax2)*SCREEN_WIDTH, WINDOW_HEIGHT*y(etuk*paikkay2));
    }
}


int main()
{
    peilaaObjekti(&volvo);
    peilaaObjekti(&porsche);

	//Start up SDL and create window
	if( !init() )
	{
		printf( "Failed to initialize!\n" );
	}
	else
	{
		//Load media
		if( !loadMedia() )
		{
			printf( "Failed to load media!\n" );
		}
		else
		{	
			//Main loop flag
			bool quit = false;

			//Event handler
			SDL_Event e;



			//While application is running
			while( !quit )
			{

				//Handle events on queue
				while( SDL_PollEvent( &e ) != 0 )
				{
                    //User requests quit
                    if( e.type == SDL_QUIT )
					{
						quit = true;
                    }
                    //User presses a key
                    else if( e.type == SDL_KEYDOWN )
                    {
                        //Select surfaces based on key press
                        switch( e.key.keysym.sym )
                        {
                            case SDLK_UP:
                            kaasuta();
                            setvakionopeus(0);
                            break;

                            case SDLK_DOWN:
                            jarruta();
                            setvakionopeus(0);
                            break;

                            case SDLK_v:
                            if(kaista>1){
                                setvakionopeus(100);
                            }else{
                                setvakionopeus(80);
                            }
                            break;

                            case SDLK_LEFT:
                            //vasemmalle();
                            kaistan+=0.001;
                            break;

                            case SDLK_RIGHT:
                            //oikealle();
                            kaistan-=0.001;
                            break;

                            default:
                            //gCurrentSurface = gKeyPressSurfaces[ KEY_PRESS_SURFACE_DEFAULT ];
                            break;
                        }
                    }
				}

				//Clear screen
				SDL_SetRenderDrawColor( gRenderer, 0xFF, 0xFF, 0xFF, 0xFF );
				SDL_RenderClear( gRenderer );





                /*

				//Render green outlined quad
				SDL_Rect outlineRect = { SCREEN_WIDTH / 6, SCREEN_HEIGHT / 6, SCREEN_WIDTH * 2 / 3, SCREEN_HEIGHT * 2 / 3 };
				SDL_SetRenderDrawColor( gRenderer, 0x00, 0xFF, 0x00, 0xFF );		
				SDL_RenderDrawRect( gRenderer, &outlineRect );
                */

				//Draw blue horizontal line
				SDL_SetRenderDrawColor( gRenderer, 0x00, 0x00, 0xFF, 0xFF );		
                SDL_RenderDrawLine( gRenderer, 0, WINDOW_HEIGHT / 2, SCREEN_WIDTH, WINDOW_HEIGHT / 2 );

                //Draw road
                SDL_RenderDrawLine( gRenderer, -SCREEN_WIDTH+kaista*SCREEN_WIDTH/2, WINDOW_HEIGHT, SCREEN_WIDTH / 2, WINDOW_HEIGHT / 2 );
                SDL_RenderDrawLine( gRenderer, SCREEN_WIDTH+kaista*SCREEN_WIDTH/2, WINDOW_HEIGHT, SCREEN_WIDTH / 2, WINDOW_HEIGHT / 2 );





                siirra();

                SDL_SetRenderDrawColor( gRenderer, 0x00, 0x00, 0xFF, 0xFF );

                //Tie
                double autox = remainder(0-matka, 9);
                for(double et=autox; et<200+autox; et+=9){
                    double takk=kulma(et+3);
                    double etuk=kulma(et);

                    //jos piste on ohitettu, aloitetaan suoraan alhaalta
                    if(et<=0){
                        etuk=90;
                    }
                    if(etuk>25){
                        etuk=25;
                    }
                    if(takk>25){
                        takk=25;
                    }

                    if(et+3>1){
                        //assert(tak<etu);
                        ///SDL_RenderDrawLine(gRenderer, SCREEN_WIDTH/2, WINDOW_HEIGHT*y(takk), SCREEN_WIDTH/2, WINDOW_HEIGHT*y(etuk));
                        double paikkax=-1+kaista;
                        SDL_RenderDrawLine(gRenderer, y(takk*paikkax)*SCREEN_WIDTH, WINDOW_HEIGHT*y(takk), y(etuk*paikkax)*SCREEN_WIDTH, WINDOW_HEIGHT*y(etuk));

                    }
                }

                //Mailimerkit
                autox = remainder(0-matka, 1609);
                for(double et=autox; et<200+autox; et+=1609){
                    double etuk=kulma(et);

                    //jos piste on ohitettu, aloitetaan suoraan alhaalta
                    if(et<=0){
                        etuk=90;
                    }
                    if(etuk>25){
                        etuk=25;
                    }

                    if(et>1){
                        double paikkax=4+kaista;
                        SDL_RenderDrawLine(gRenderer,
                                           y(etuk*paikkax)*SCREEN_WIDTH, WINDOW_HEIGHT*y(etuk*0.5),
                                           y(etuk*paikkax)*SCREEN_WIDTH, WINDOW_HEIGHT*y(etuk*1.5));

                    }
                }


                //kaista 1
                const double muidenvali=100;
                double lahinauto = remainder(0-matka+muidenMatka(100), muidenvali);
                //int autonumero = (-(0.0-matka+muidenMatka(100)+0.5) / muidenvali);
                //double lahinauto =  (0-matka+muidenMatka(100))-autonumero*muidenvali;

                //std::cout << autonumero << std::endl;
                //if(autonumero % 3){

                assert(lahinauto>2 || lahinauto<1 || kaista<1);

                //}

                for(double et=lahinauto; et<200+lahinauto; et+=muidenvali){
                    ///if(autonumero % 3){
                        double etuk=kulma(et);
                        if(et<=0){
                            etuk=90;
                        }
                        if(etuk>25){
                            etuk=25;
                        }
                        if(et>1){
                            if(true){
                                piirraObjekti(porsche, etuk, -2+kaista);
                            }else{
                                piirraObjekti(volvo, etuk, -2+kaista);
                            }

                        }
                    //}
                    //autonumero--;
                }


                //kaista 2
                {
                    const double muidenvali=80;
                    double lahinauto = remainder(0-matka+muidenMatka(80), muidenvali);
                    assert(lahinauto>2 || lahinauto<1 || kaista>1);
                    for(double et=lahinauto; et<200+lahinauto; et+=muidenvali){
                        double etuk=kulma(et);
                        if(et<=0){
                            etuk=90;
                        }
                        if(etuk>25){
                            etuk=25;
                        }
                        if(et>1){
                            piirraObjekti(volvo, etuk, kaista);
                        }
                    }
                }

                //Draw cockpit
                SDL_Rect fillRect2 = {  0, WINDOW_HEIGHT, SCREEN_WIDTH,SCREEN_WIDTH-WINDOW_HEIGHT};
                SDL_SetRenderDrawColor( gRenderer, 0x00, 0x00, 0x00, 0xFF );
                SDL_RenderFillRect( gRenderer, &fillRect2 );

                SDL_Rect fillRect1 = {  0, WINDOW_HEIGHT, SCREEN_WIDTH,int((SCREEN_WIDTH-WINDOW_HEIGHT)*0.05)};
                SDL_SetRenderDrawColor( gRenderer, 0xF0, 0x00, 0x00, 0xFF );
                SDL_RenderFillRect( gRenderer, &fillRect1 );



                //Render red filled quad
                if(poljin_kaasu){
                    SDL_Rect fillRect = { int(SCREEN_WIDTH *0.15), SCREEN_HEIGHT - poljin_kaasu*30, int(SCREEN_WIDTH *0.05), SCREEN_HEIGHT};
                    SDL_SetRenderDrawColor( gRenderer, 0x00, 0xFF, 0x00, 0xFF );
                    SDL_RenderFillRect( gRenderer, &fillRect );
                }

                //Render red filled quad
                if(poljin_jarru){
                    SDL_Rect fillRect = { int(SCREEN_WIDTH *0.05), SCREEN_HEIGHT - poljin_jarru*15, int(SCREEN_WIDTH *0.075), SCREEN_HEIGHT};
                    SDL_SetRenderDrawColor( gRenderer, 0xFF, 0x00, 0x00, 0xFF );
                    SDL_RenderFillRect( gRenderer, &fillRect );
                }

                //nopeusmittari
                piirraNopeusmittari();


				//Update screen
				SDL_RenderPresent( gRenderer );
			}
		}
	}

	//Free resources and close SDL
	close();

	return 0;
}
